classdef HW4VirtualFixture
%  Virtual Fixture class definition for HW4
% 
% Copyright (C) Russell H. Taylor 2013
% For use with CIS I only
% Do not redistribute without written permission from Russell Taylor
%
    
    properties
        Fc      % position compliance frame (for forces)     
        Kplus   % position stiffness gains
        Kminus
        Bplus   % position bias gains
        Bminus  % 
        Gplus   % force bias terms
        Gminus
        Ro      % Rotation compliance frame (for torques)
        Koplus  % Orientation compliance gains
        Kominus
        Tauplus % Torque bias terms
        Tauminus
        Timeleft % Time to go until timeout
    end
    
    methods
        function V=HW4VirtualFixture(Fc,Kplus,Kminus,Bplus,Bminus,Gplus,Gminus, ...
                                        Ro,Koplus,Kominus,Tauplus,Tauminus)
 
            V.Fc        = Fc;       % position compliance frame (for forces)     
            V.Kplus     = Kplus;    % position stiffness gains
            V.Kminus    = Kminus;
            V.Bplus     = Bplus;    % position bias gains
            V.Bminus    = Bminus;   % 
            V.Gplus     = Gplus;    % force bias terms
            V.Gminus    = Gminus;
            V.Ro        = Ro;       % Rotation compliance frame (for torques)
            V.Koplus    = K0Plus;   % Orientation compliance gains
            V.Kominus   = K0Minus;
            V.Tauplus   = Tauplus;  % Torque bias terms
            V.Tauminus  = Tauminus;
            V.Timeleft  = Inf;      % Time to go until timeout
        end
        
        function [f,t] = EvaluateHapticForceTorque(V,F,vel)
            Fci = V.Fc.Inverse();
            q = (Fci*F.p); q=q.el;
            v = (Fci.R*vel); v=v.el;
            DR = Ro.inverse()*F.R;
            [ax,an] = DR.AxisAngle();
            rv = (ax*an); rv=rv.el;
            f = [0,0,0]'; t=[0,0,0]';
            for i=1:3
                if q(i)<0 f(i)=Kminus(i)*q(i)+Bminus(i)*v(i)+Gminus(i);
                else      f(i)=Kplus(i)*q(i)+Bplus(i)*v(i)+Gplus(i); end
                if rv(i)<0 t(i) = Kominus(i)*rv(i)+Tauminus(i);
                else       t(i) = Koplus(i)*rv(i)+Tauplus(i); end
            end
            f = V.Fc.R*vct3(f); 
            t = V.Ro*vct3(t);
        end
    end
    
end

